;
; Copyright @ F. Durvaux, L. Lerman, F. Koeune, 2014-2016.
; e-mail: <francois.durvaux@uclouvain.be>, <francois.koeune@uclouvain.be>, <llerman@ulb.ac.be>
;
;
; To the extent possible under law, the author(s) have dedicated all
; copyright and related and neighboring rights to this software to the
; public domain worldwide. This software is distributed without any
; warranty.
;
; You should have received a copy of the CC0 Public Domain Dedication
; along with this software. If not, see
; <http://creativecommons.org/publicdomain/zero/1.0/>


 .include "tn85def.inc"

 

.CSEG

.EQU	NONCE_NUM_BYTE = 11									;   Nonce size in bytes (since blocks are actually counted with a 2-byte counter, maximum value allowed is 13)
.EQU	NONCE_PAD_NUM_BYTE = 13 - NONCE_NUM_BYTE			;	Number of 0 bytes between N and actual c in tweak

.EQU	BLOCK_NUM_BYTE = 16

;#define SCREAMV10
#define SCREAMV12

#ifdef SCREAMV10
.EQU	NUMBER_ROUNDS = 20
#elif SCREAMV12
.EQU	NUMBER_ROUNDS = 24
#else
 PROBLEM
#endif
.EQU	ROUND_CST_INC_LSB = low(2199)
.EQU	ROUND_CST_INC_MSB = high(2199)
.EQU	MAX_ROUND_CST_LSB = low((NUMBER_ROUNDS*2199)%65536)
.EQU	MAX_ROUND_CST_MSB = high((NUMBER_ROUNDS*2199)%65536)

.EQU	LAST_TWEAK_ID = (NUMBER_ROUNDS/2 )%3








;cipher internal state:
;8 x 16-bit words (rows)
;w0 = s0 || s8 = LSB || MSB
;w1 = s1 || s9 = LSB || MSB
;...
;w7 = s7 || s15 = LSB || MSB

;
; Declaration of the used registers:
;
;state registers
.def s0 = R0
.def s1 = R1
.def s2 = R2
.def s3 = R3
.def s4 = R4
.def s5 = R5
.def s6 = R6
.def s7 = R7
.def s8 = R8
.def s9 = R9
.def s10 = R10
.def s11 = R11
.def s12 = R12
.def s13 = R13
.def s14 = R14
.def s15 = R15
;temporary registers
.def tmp0 = R16
.def tmp1 = R17	
.def tmp2 = R18
.def tmp3 = R19
.def tmp4 = R20
.def tmp5 = R21
.def tmp6 = R22
.def tmp7 = R23
.def tmp8 = R24
.def tmp9 = R25
;.def tmp10= R26
.def I = R26 ; round index

; alias temporary registers
.def T = R27 ; tweak index
.def C_LSB = R28 ; LSB of the round constant
.def C_MSB = R29 ; MSB of the round constant

;- X = R27:26
;- Y = R29:28
;- Z = R31:30

.DSEG
	SRAM_DATA:
	SRAM_TAG:		.BYTE 16
	SRAM_KEY:		.BYTE 16
	SRAM_TWEAK1:	.BYTE 16
	SRAM_TWEAK2:	.BYTE 16
	SRAM_TWEAK3:	.BYTE 16
	SRAM_TWEAK:		.BYTE 16
	SRAM_SIGMA:		.BYTE 16
	SRAM_BUF:		.BYTE 16
													; Remainder for test purpose only (this is the place in flash where test vectors are stored) 
	SRAM_ADDITIONALPT:	.BYTE 16							 
	SRAM_ADDITIONALKEY:	.BYTE 16
	SRAM_ADDITIONALADATA: .BYTE 16
	SRAM_ADDITIONALREFTAG: .BYTE 16
	SRAM_ADDITIONALNONCE: .BYTE 12
