;
; Copyright @ F. Durvaux, L. Lerman, F. Koeune, 2014-2016.
; e-mail: <francois.durvaux@uclouvain.be>, <francois.koeune@uclouvain.be>, <llerman@ulb.ac.be>
;
;
; To the extent possible under law, the author(s) have dedicated all
; copyright and related and neighboring rights to this software to the
; public domain worldwide. This software is distributed without any
; warranty.
;
; You should have received a copy of the CC0 Public Domain Dedication
; along with this software. If not, see
; <http://creativecommons.org/publicdomain/zero/1.0/>


.include "headers.asm"

.cseg

; global interrupt disable
	cli
; initialize stack
	ldi		r31,HIGH(RAMEND)
	out		SPH,r31
	ldi		r31,LOW(RAMEND)
	out		SPL,r31

; initialize trigger B1
  	ldi		r16, 0b11	; portB,1 = output (triggers)
  	out		DDRB, r16

	rjmp	main

.include "scream_bc.asm"
.include "SCREAM_TAE.asm"


;******************** FUNCTIONS ***********************************
; This function copy bytes from ROM location pointed by ZH:ZL to
; SRAM location pointed by XH:XL
;	Z must contain source address
;	X must contain destination address
;	r18 must contain the number of byte to copy
;	r16 is used for internal computation
copy_word:
	lpm		r16, Z+
	st 		X+,r16
	dec		r18
	brbc	1, copy_word
	ret
;*******************************************************************




main:

; ++++++++++++++++++ SIMPLE BC TEST ++++++++++++++++++++++++++++++++++++
;	;LOAD THE PTEXT FROM THE DB BELOW TO SRAM
;	ldi		ZH, high(text<<1)
;	ldi		ZL, low(text<<1)
;	ldi 	XH, high(SRAM_ADDITIONALPT)
;	ldi 	XL, low(SRAM_ADDITIONALPT)
;	ldi		r18, BLOCK_NUM_BYTE
;	rcall	copy_word

	;LOAD THE KEY FROM THE DB BELOW TO SRAM
;	ldi		ZH, high(key<<1)
;	ldi		ZL, low(key<<1)
;	ldi 	XH, high(SRAM_KEY)
;	ldi 	XL, low(SRAM_KEY)
;	ldi		r18, BLOCK_NUM_BYTE
;	rcall	copy_word

;	;LOAD THE TWEAK FROM THE DB BELOW TO SRAM
;	ldi		ZH, high(tweak<<1)
;	ldi		ZL, low(tweak<<1)
;	ldi 	XH, high(SRAM_TWEAK)
;	ldi 	XL, low(SRAM_TWEAK)
;	ldi		r18, BLOCK_NUM_BYTE
;	rcall	copy_word
;	ldi		XH,high(SRAM_ADDITIONALKEY)
;	ldi		XL,low(SRAM_ADDITIONALKEY)
;	ldi		YH,high(sram_tweak)
;	ldi		YL,low(sram_tweak)
;	rcall   preparing_round_keys
;	ldi 	ZH, high(SRAM_ADDITIONALPT)
;	ldi 	ZL, low(SRAM_ADDITIONALPT)
;	rcall	encrypt		; encryption routine
;
;	ldi		XH,high(SRAM_ADDITIONALKEY)
;	ldi		XL,low(SRAM_ADDITIONALKEY)
;	ldi		YH,high(sram_tweak)
;	ldi		YL,low(sram_tweak)
;	rcall   preparing_round_keys
;	ldi 	ZH, high(SRAM_ADDITIONALPT)
;	ldi 	ZL, low(SRAM_ADDITIONALPT)
;	rcall	decrypt
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


; ++++++++++++++++++ MODES TEST : encrypt ++++++++++++++++++++++++++++++

	ldi		ZH, high(key<<1)
	ldi		ZL, low(key<<1)
	ldi 	XH, high(SRAM_ADDITIONALKEY)
	ldi 	XL, low(SRAM_ADDITIONALKEY)
	ldi		r18, BLOCK_NUM_BYTE
	rcall	copy_word

	ldi		ZH, high(nonce<<1)
	ldi		ZL, low(nonce<<1)
	ldi		XH,high(SRAM_ADDITIONALNONCE)
	ldi		XL,low(SRAM_ADDITIONALNONCE)
	ldi		r18, NONCE_NUM_BYTE
	rcall	copy_word


	ldi		ZH,high(SRAM_ADDITIONALNONCE)
	ldi		ZL,low(SRAM_ADDITIONALNONCE)
	ldi		XH,high(SRAM_ADDITIONALKEY)
	ldi		XL,low(SRAM_ADDITIONALKEY)

	rcall	TAE_Init
	rcall	TAE_Init_AData 

	ldi		ZH, high(adatalength<<1)
	ldi		ZL, low(adatalength<<1)
	lpm		r19, z								; r19 = adatalength

	ldi		ZH, high(adata<<1)
	ldi		ZL, low(adata<<1)

Main_NextAdata:
	cpi		r19,17								; while r19 > 16, process non-last block
	brlo	Main_LastAdata

	ldi		XH,high(SRAM_ADDITIONALADATA)
	ldi		XL,low(SRAM_ADDITIONALADATA)
	ldi		r18,16
	rcall	copy_word
	push	ZH
	push	ZL
	push	r19
	ldi		ZH,high(SRAM_ADDITIONALADATA)
	ldi		ZL,low(SRAM_ADDITIONALADATA)
	rcall	TAE_Next_AData
	pop		r19
	pop		ZL
	pop		ZH
	subi	r19,16
	rjmp	Main_NextAdata

Main_LastAdata:
	ldi		XH,high(SRAM_ADDITIONALADATA)
	ldi		XL,low(SRAM_ADDITIONALADATA)
	mov		r18,r19
	rcall	copy_word
	ldi		ZH,high(SRAM_ADDITIONALADATA)
	ldi		ZL,low(SRAM_ADDITIONALADATA)
	mov		r16,r19
	rcall	TAE_Last_AData


	rcall	TAE_Init_Encrypt

	ldi		ZH, high(textlength<<1)
	ldi		ZL, low(textlength<<1)
	lpm		r19, z								; r19 = textlength

	ldi		ZH, high(text<<1)
	ldi		ZL, low(text<<1)

Main_NextEncrypt:
	cpi		r19, 17
	brlo	Main_LastEncrypt
	ldi 	XH, high(SRAM_ADDITIONALPT)
	ldi 	XL, low(SRAM_ADDITIONALPT)
	ldi		r18, BLOCK_NUM_BYTE
	rcall	copy_word
	push	ZH
	push	ZL
	push	r19
	ldi 	zH, high(SRAM_ADDITIONALPT)
	ldi 	zL, low(SRAM_ADDITIONALPT)

	rcall	TAE_Next_Encrypt
		pop		r19
	pop		ZL
	pop		ZH
	subi	r19,16
	rjmp	Main_NextEncrypt
Main_Lastencrypt:
	ldi 	XH, high(SRAM_ADDITIONALPT)
	ldi 	XL, low(SRAM_ADDITIONALPT)
	mov		r18, r19
	rcall	copy_word
	ldi 	zH, high(SRAM_ADDITIONALPT)
	ldi 	zL, low(SRAM_ADDITIONALPT)
	mov		r16,r19
	rcall	TAE_Last_Encrypt

	nop


; ++++++++++++++++++ MODES TEST : decrypt ++++++++++++++++++++++++++++++


	ldi		ZH, high((tag)<<1)
	ldi		ZL, low((tag)<<1)
	ldi 	XH, high(SRAM_ADDITIONALREFTAG)
	ldi 	XL, low(SRAM_ADDITIONALREFTAG)
	ldi		r18, BLOCK_NUM_BYTE
	rcall	copy_word

	ldi		ZH, high(key<<1)
	ldi		ZL, low(key<<1)
	ldi 	XH, high(SRAM_ADDITIONALKEY)
	ldi 	XL, low(SRAM_ADDITIONALKEY)
	ldi		r18, BLOCK_NUM_BYTE
	rcall	copy_word

	ldi		ZH, high(nonce<<1)
	ldi		ZL, low(nonce<<1)
	ldi		XH,high(SRAM_ADDITIONALNONCE)
	ldi		XL,low(SRAM_ADDITIONALNONCE)
	ldi		r18, NONCE_NUM_BYTE
	rcall	copy_word

	ldi		ZH,high(SRAM_ADDITIONALNONCE)
	ldi		ZL,low(SRAM_ADDITIONALNONCE)
	ldi		XH,high(SRAM_ADDITIONALKEY)
	ldi		XL,low(SRAM_ADDITIONALKEY)

	rcall	TAE_Init
	rcall	TAE_Init_AData 


	ldi		ZH, high(adatalength<<1)
	ldi		ZL, low(adatalength<<1)
	lpm		r19, z								; r19 = adatalength

	ldi		ZH, high(adata<<1)
	ldi		ZL, low(adata<<1)

Main_NextAdataD:
	cpi		r19,17								; while r19 > 16, process non-last block
	brlo	Main_LastAdataD

	ldi		XH,high(SRAM_ADDITIONALADATA)
	ldi		XL,low(SRAM_ADDITIONALADATA)
	ldi		r18,16
	rcall	copy_word
	push	ZH
	push	ZL
	push	r19
	ldi		ZH,high(SRAM_ADDITIONALADATA)
	ldi		ZL,low(SRAM_ADDITIONALADATA)
	rcall	TAE_Next_AData
	pop		r19
	pop		ZL
	pop		ZH
	subi	r19,16
	rjmp	Main_NextAdataD

Main_LastAdataD:
	ldi		XH,high(SRAM_ADDITIONALADATA)
	ldi		XL,low(SRAM_ADDITIONALADATA)
	mov		r18,r19
	rcall	copy_word
	ldi		ZH,high(SRAM_ADDITIONALADATA)
	ldi		ZL,low(SRAM_ADDITIONALADATA)
	mov		r16,r19
	rcall	TAE_Last_AData

	rcall	TAE_Init_Decrypt

	ldi		ZH, high(cipherlength<<1)
	ldi		ZL, low(cipherlength<<1)
	lpm		r19, z								; r19 = cipherlength

	ldi		ZH, high(cipher<<1)
	ldi		ZL, low(cipher<<1)

Main_NextDecrypt:
	cpi		r19, 17
	brlo	Main_LastDecrypt
	ldi 	XH, high(SRAM_ADDITIONALPT)
	ldi 	XL, low(SRAM_ADDITIONALPT)
	ldi		r18, BLOCK_NUM_BYTE
	rcall	copy_word
	push	ZH
	push	ZL
	push	r19
	ldi 	zH, high(SRAM_ADDITIONALPT)
	ldi 	zL, low(SRAM_ADDITIONALPT)
	rcall	TAE_Next_Decrypt
	pop		r19
	pop		ZL
	pop		ZH
	subi	r19,16
	rjmp	Main_NextDecrypt
Main_LastDecrypt:
	ldi 	XH, high(SRAM_ADDITIONALPT)
	ldi 	XL, low(SRAM_ADDITIONALPT)
	mov		r18, r19
	rcall	copy_word
	ldi 	zH, high(SRAM_ADDITIONALPT)
	ldi 	zL, low(SRAM_ADDITIONALPT)
	mov		r16,r19

	ldi 	XH, high(SRAM_ADDITIONALREFTAG)
	ldi 	XL, low(SRAM_ADDITIONALREFTAG)
	rcall	TAE_Last_Decrypt
	
	nop
	nop
	nop

	textlength:
.db 102
text:
.db $6b,$36,$f3,$3f,$f8,$82,$e4,$32,$86,$14,$48,$a6,$11,$83,$58,$3b,$0d,$f1,$f9,$08,$59,$34,$81,$53,$5b,$6e,$bb,$c6,$ab,$fc,$07,$ae,$22,$cd,$50,$a3,$31,$67,$83,$01,$fd,$85,$35,$69,$03,$35,$dc,$be,$91,$d9,$2b,$a1,$c9,$bd,$e3,$0d,$5e,$2f,$0e,$c7,$cd,$d6,$fb,$f8,$bd,$27,$d4,$cf,$ec,$51,$6e,$34,$17,$99,$d8,$fb,$bb,$7b,$ec,$28,$9c,$0e,$2c,$40,$58,$46,$08,$57,$80,$eb,$87,$d7,$3e,$8a,$f2,$50,$87,$a2,$a2,$20,$7a,$04
key:
.db $2f,$f6,$96,$3d,$d7,$24,$62,$ab,$67,$d5,$da,$22,$c0,$e2,$64,$ae
adatalength:
.db 51
adata:
.db $5c,$0e,$6a,$47,$bc,$14,$66,$79,$d2,$d6,$4a,$ca,$57,$74,$63,$67,$97,$82,$95,$34,$01,$57,$eb,$9d,$25,$81,$bf,$bb,$14,$a0,$cb,$39,$15,$fc,$eb,$58,$30,$da,$3a,$fe,$a9,$ff,$db,$bb,$cf,$0e,$bd,$bd,$ae,$bd,$32
nonce:
.db $e9,$e6,$f9,$28,$1b,$86,$c8,$47,$0b,$a1,$20
cipherlength:
.db 102
cipher:
.db $c9,$01,$8e,$f2,$80,$4f,$85,$e0,$de,$4d,$65,$19,$59,$3a,$3e,$5e,$d8,$3c,$22,$bd,$c8,$b2,$db,$22,$29,$e6,$80,$10,$71,$cd,$ea,$67,$85,$85,$6f,$ea,$c8,$3b,$be,$33,$5c,$6b,$cb,$2f,$5f,$6d,$81,$a6,$cf,$14,$c7,$14,$62,$fd,$e6,$d6,$05,$2e,$fb,$d1,$99,$5c,$1a,$46,$1c,$3c,$51,$a2,$dd,$6a,$12,$23,$d1,$0b,$7a,$b7,$69,$c8,$12,$16,$27,$df,$84,$bd,$c7,$d1,$c8,$88,$d3,$88,$23,$a6,$97,$99,$b7,$b5,$c1,$c8,$c1,$e4,$b8,$92
tag:
.db $84,$67,$0e,$f3,$aa,$ba,$9e,$e5,$d7,$35,$88,$58,$c6,$5c,$41,$ed

