;
; Copyright @ F. Durvaux, L. Lerman, F. Koeune, 2014-2016.
; e-mail: <francois.durvaux@uclouvain.be>, <francois.koeune@uclouvain.be>, <llerman@ulb.ac.be>
;
;
; To the extent possible under law, the author(s) have dedicated all
; copyright and related and neighboring rights to this software to the
; public domain worldwide. This software is distributed without any
; warranty.
;
; You should have received a copy of the CC0 Public Domain Dedication
; along with this software. If not, see
; <http://creativecommons.org/publicdomain/zero/1.0/>



; copy the state from memory to 16 registers
; initialize ZH and ZL accordingly to where the state is
load_state:
	ld s0, z+;
	ld s8, z+;
	ld s1, z+;
	ld s9, z+;
	ld s2, z+;
	ld s10, z+;
	ld s3, z+;
	ld s11, z+;
	ld s4, z+;
	ld s12, z+;
	ld s5, z+;
	ld s13, z+;
	ld s6, z+;
	ld s14, z+;
	ld s7, z+;
	ld s15, z+;
	ret;

; copy the state the 16 registers to the memory
; initialize ZH and ZL accordingly to where the state is
store_state:
	st z+, s0;
	st z+, s8;
	st z+, s1;
	st z+, s9;
	st z+, s2;
	st z+, s10;
	st z+, s3;
	st z+, s11;
	st z+, s4;
	st z+, s12;
	st z+, s5;
	st z+, s13;
	st z+, s6;
	st z+, s14;
	st z+, s7;
	st z+, s15;
	ret;

;==================================================
; Tweakey generation
;
; X must contain the pointer to the key
; Y must contain the pointer to the tweak
; 
; Tweakey is generated and stored in SRAM_TWEAKEY1..3
;==================================================
	
preparing_round_keys:
	;-- t0 = s0 || s8 || s1 || s9 || ... || s11
	;-- t1 = s4 || s12 || s5 || s13 || ... || s15
	;-- 3rd: k0+t1 || k1+t0+t1

	mov		ZL, YL
	mov		ZH, YH
	rcall load_state
	mov tmp0, s0
	mov tmp1, s8
	mov tmp2, s1
	mov tmp3, s9
	mov tmp4, s2
	mov tmp5, s10
	mov tmp6, s3
	mov tmp7, s11
	mov s0, s4
	mov s8, s12
	mov s1, s5
	mov s9, s13
	mov s2, s6
	mov s10, s14
	mov s3, s7
	mov s11, s15
	eor s4, tmp0
	eor s12, tmp1
	eor s5, tmp2
	eor s13, tmp3
	eor s6, tmp4
	eor s14, tmp5
	eor s7, tmp6
	eor s15, tmp7
	mov	ZL, XL
	mov	ZH, XH
	rcall key_addition
	ldi ZH,high(sram_tweak3)
	ldi ZL,low(sram_tweak3)
	rcall store_state
	;-- 2nd: k0+t0+t1 || k1+t0
	mov	ZL, YL
	mov	ZH, YH
	rcall load_state
	mov tmp0, s4
	mov tmp1, s12
	mov tmp2, s5
	mov tmp3, s13
	mov tmp4, s6
	mov tmp5, s14
	mov tmp6, s7
	mov tmp7, s15
	mov s4, s0
	mov s12, s8
	mov s5, s1
	mov s13, s9
	mov s6, s2
	mov s14, s10
	mov s7, s3
	mov s15, s11
	eor s0, tmp0
	eor s8, tmp1
	eor s1, tmp2
	eor s9, tmp3
	eor s2, tmp4
	eor s10, tmp5
	eor s3, tmp6
	eor s11, tmp7
	mov ZL, XL
	mov ZH, XH
	rcall key_addition
	ldi ZH,high(sram_tweak2)
	ldi ZL,low(sram_tweak2)
	rcall store_state
	;-- 1nd: k0+t0 || k1+t1  or tweak2 + (t1 || t0+t1)
	mov	ZL, YL
	mov	ZH, YH
	rcall load_state
	mov ZL, XL
	mov ZH, XH
	rcall key_addition
	ldi ZH,high(sram_tweak1)
	ldi ZL,low(sram_tweak1)
	rcall store_state
	ret
	
;==================================================
; encryption
;
; Z must contain the pointer to the data to encrypt (which will be overwritten with ciphertext)
; and the key must have been prepared by preparing_round_keys
; 
;==================================================

encrypt:
	push	ZH
	push	ZL
	rcall load_state					; load plaintext in state

	ldi		ZH, high(SRAM_TWEAK1)
	ldi		ZL, low(SRAM_TWEAK1)
	rcall key_addition					; first key addition  		
	ldi I, 0
	ldi T, 0
	ldi C_LSB, 0
	ldi C_MSB, 0

	encrypt_round:
	
		;bitsliced sbox layer: s0->s7
		mov tmp0, s0
		mov tmp1, s1
		mov tmp2, s2
		mov tmp3, s3
		mov tmp4, s4
		mov tmp5, s5
		mov tmp6, s6
		mov tmp7, s7
		rcall sbox_layer
		mov s0, tmp0
		mov s1, tmp1
		mov s2, tmp2
		mov s3, tmp3
		mov s4, tmp4
		mov s5, tmp5
		mov s6, tmp6
		mov s7, tmp7
		
		;bitsliced sbox layer: s8->s15
		mov tmp0, s8
		mov tmp1, s9
		mov tmp2, s10
		mov tmp3, s11
		mov tmp4, s12
		mov tmp5, s13
		mov tmp6, s14
		mov tmp7, s15
		rcall sbox_layer
		mov s8, tmp0
		mov s9, tmp1
		mov s10, tmp2
		mov s11, tmp3
		mov s12, tmp4
		mov s13, tmp5
		mov s14, tmp6
		mov s15, tmp7
	
		;round constant addition
		eor s8, C_MSB
		eor s0, C_LSB
		
		;linear layer
		;registers tmp0..7 correspond to s0..7
		ldi ZH, high(L1_H<<1)
		mov ZL, s0
		lpm tmp0, Z
		mov ZL, s1
		lpm tmp1, Z
		mov ZL, s2
		lpm tmp2, Z
		mov ZL, s3
		lpm tmp3, Z
		mov ZL, s4
		lpm tmp4, Z
		mov ZL, s5
		lpm tmp5, Z
		mov ZL, s6
		lpm tmp6, Z
		mov ZL, s7
		lpm tmp7, Z
		
		ldi ZH, high(L2_H<<1)
		mov ZL, s8
		lpm tmp8, Z
		eor tmp0, tmp8
		mov ZL, s9
		lpm tmp8, Z
		eor tmp1, tmp8
		mov ZL, s10
		lpm tmp8, Z
		eor tmp2, tmp8
		mov ZL, s11
		lpm tmp8, Z
		eor tmp3, tmp8
		mov ZL, s12
		lpm tmp8, Z
		eor tmp4, tmp8
		mov ZL, s13
		lpm tmp8, Z
		eor tmp5, tmp8
		mov ZL, s14
		lpm tmp8, Z
		eor tmp6, tmp8
		mov ZL, s15
		lpm tmp8, Z
		eor tmp7, tmp8
		
		ldi ZH, high(L2_L<<1)
		mov ZL, s15
		lpm tmp8, Z
		mov s15, tmp7
		mov ZL, s14
		lpm tmp7, Z
		mov s14, tmp6
		mov ZL, s13
		lpm tmp6, Z
		mov s13, tmp5
		mov ZL, s12
		lpm tmp5, Z
		mov s12, tmp4
		mov ZL, s11
		lpm tmp4, Z
		mov s11, tmp3
		mov ZL, s10
		lpm tmp3, Z
		mov s10, tmp2
		mov ZL, s9
		lpm tmp2, Z
		mov s9, tmp1
		mov ZL, s8
		lpm tmp1, Z
		mov s8, tmp0
		
		;registers tmp1..8 correspond to s0..7 -- trick for speeding up the code
		ldi ZH, high(L1_L<<1)	
		mov ZL, s7
		lpm s7, Z
		eor s7, tmp8
		mov ZL, s6
		lpm s6, Z
		eor s6, tmp7
		mov ZL, s5
		lpm s5, Z
		eor s5, tmp6
		mov ZL, s4
		lpm s4, Z
		eor s4, tmp5
		mov ZL, s3
		lpm s3, Z
		eor s3, tmp4
		mov ZL, s2
		lpm s2, Z
		eor s2, tmp3
		mov ZL, s1
		lpm s1, Z
		eor s1, tmp2
		mov ZL, s0
		lpm s0, Z
		eor s0, tmp1

		ldi tmp0, round_cst_inc_lsb
		ldi tmp1, round_cst_inc_msb
		add C_LSB, tmp0
		adc C_MSB, tmp1

		inc I
		ldi tmp0, $01
		and tmp0, I
		cpi tmp0, $00
		brne encrypt_test
		
		inc T
		cpi T, $03
		breq encrypt_tweak1_addition
		cpi T, $01
		breq encrypt_tweak2_addition
		rjmp encrypt_tweak3_addition
		
	encrypt_tweak1_addition:
		ldi T, 0
		ldi ZH,high(sram_tweak1)
		ldi ZL,low(sram_tweak1)
		rcall key_addition
		rjmp encrypt_test
	
	encrypt_tweak2_addition:
		ldi ZH,high(sram_tweak2)
		ldi ZL,low(sram_tweak2)
		rcall key_addition
		rjmp encrypt_test
	
	encrypt_tweak3_addition:
		ldi ZH,high(sram_tweak3)
		ldi ZL,low(sram_tweak3)
		rcall key_addition
		rjmp encrypt_test
	
	encrypt_test:
		cpi I, number_rounds
		breq encrypt_done
		rjmp encrypt_round
		
	encrypt_done:
		pop		ZL
		pop		ZH
		rcall store_state;

		ret
	



;decryption
decrypt:
	; Z contains the pointer to the data to decrypt
	push	zh
	push	zl
	rcall load_state

	ldi I, number_rounds
	ldi T, last_tweak_id

	ldi C_LSB, max_round_cst_lsb
	ldi C_MSB, max_round_cst_msb

#ifdef SCREAMV10
		ldi ZH,high(sram_tweak2)
		ldi ZL,low(sram_tweak2)
#elif SCREAMV12
		ldi ZH,high(sram_tweak1)
		ldi ZL,low(sram_tweak1)
#else
 PROBLEM
#endif
	
		rcall key_addition

	decrypt_round:
	    dec I

		ldi tmp0, round_cst_inc_lsb
		ldi tmp1, round_cst_inc_msb
		subi C_LSB, round_cst_inc_lsb
		sbci C_MSB, round_cst_inc_msb

		;linear layer
		;registers tmp0..7 correspond to s0..7
		ldi ZH, high(L1_H_INV<<1)
		mov ZL, s0
		lpm tmp0, Z
		mov ZL, s1
		lpm tmp1, Z
		mov ZL, s2
		lpm tmp2, Z
		mov ZL, s3
		lpm tmp3, Z
		mov ZL, s4
		lpm tmp4, Z
		mov ZL, s5
		lpm tmp5, Z
		mov ZL, s6
		lpm tmp6, Z
		mov ZL, s7
		lpm tmp7, Z
		
		ldi ZH, high(L2_H_INV<<1)
		mov ZL, s8
		lpm tmp8, Z
		eor tmp0, tmp8
		mov ZL, s9
		lpm tmp8, Z
		eor tmp1, tmp8
		mov ZL, s10
		lpm tmp8, Z
		eor tmp2, tmp8
		mov ZL, s11
		lpm tmp8, Z
		eor tmp3, tmp8
		mov ZL, s12
		lpm tmp8, Z
		eor tmp4, tmp8
		mov ZL, s13
		lpm tmp8, Z
		eor tmp5, tmp8
		mov ZL, s14
		lpm tmp8, Z
		eor tmp6, tmp8
		mov ZL, s15
		lpm tmp8, Z
		eor tmp7, tmp8
		
		ldi ZH, high(L2_L_INV<<1)
		mov ZL, s15
		lpm tmp8, Z
		mov s15, tmp7
		mov ZL, s14
		lpm tmp7, Z
		mov s14, tmp6
		mov ZL, s13
		lpm tmp6, Z
		mov s13, tmp5
		mov ZL, s12
		lpm tmp5, Z
		mov s12, tmp4
		mov ZL, s11
		lpm tmp4, Z
		mov s11, tmp3
		mov ZL, s10
		lpm tmp3, Z
		mov s10, tmp2
		mov ZL, s9
		lpm tmp2, Z
		mov s9, tmp1
		mov ZL, s8
		lpm tmp1, Z
		mov s8, tmp0
		
		;registers tmp1..8 correspond to s0..7 -- trick for speeding up the code
		ldi ZH, high(L1_L_INV<<1)	
		mov ZL, s7
		lpm s7, Z
		eor s7, tmp8
		mov ZL, s6
		lpm s6, Z
		eor s6, tmp7
		mov ZL, s5
		lpm s5, Z
		eor s5, tmp6
		mov ZL, s4
		lpm s4, Z
		eor s4, tmp5
		mov ZL, s3
		lpm s3, Z
		eor s3, tmp4
		mov ZL, s2
		lpm s2, Z
		eor s2, tmp3
		mov ZL, s1
		lpm s1, Z
		eor s1, tmp2
		mov ZL, s0
		lpm s0, Z
		eor s0, tmp1

		;round constant addition
		eor s0, C_LSB
		eor s8, C_MSB

		;bitsliced sbox layer: s0->s7
		mov tmp0, s0
		mov tmp1, s1
		mov tmp2, s2
		mov tmp3, s3
		mov tmp4, s4
		mov tmp5, s5
		mov tmp6, s6
		mov tmp7, s7
		rcall sbox_inv_layer
		mov s0, tmp0
		mov s1, tmp1
		mov s2, tmp2
		mov s3, tmp3
		mov s4, tmp4
		mov s5, tmp5
		mov s6, tmp6
		mov s7, tmp7
		
		;bitsliced sbox layer: s8->s15
		mov tmp0, s8
		mov tmp1, s9
		mov tmp2, s10
		mov tmp3, s11
		mov tmp4, s12
		mov tmp5, s13
		mov tmp6, s14
		mov tmp7, s15
		rcall sbox_inv_layer
		mov s8, tmp0
		mov s9, tmp1
		mov s10, tmp2
		mov s11, tmp3
		mov s12, tmp4
		mov s13, tmp5
		mov s14, tmp6
		mov s15, tmp7
	

		ldi tmp0, $01
		and tmp0, I
		cpi tmp0, $00
		brne decrypt_test
		
		dec T
		cpi T, $00
		breq decrypt_tweak1_addition
		cpi T, $01
		breq decrypt_tweak2_addition
		rjmp decrypt_tweak3_addition
		
	decrypt_tweak1_addition:
		ldi ZH,high(sram_tweak1)
		ldi ZL,low(sram_tweak1)
		rcall key_addition
		rjmp decrypt_test
	
	decrypt_tweak2_addition:
		ldi ZH,high(sram_tweak2)
		ldi ZL,low(sram_tweak2)
		rcall key_addition
		rjmp decrypt_test
	
	decrypt_tweak3_addition:
		ldi T, $02
		ldi ZH,high(sram_tweak3)
		ldi ZL,low(sram_tweak3)
		rcall key_addition
		rjmp decrypt_test
	
	decrypt_test:
		cpi I, 0
		breq decrypt_done
		rjmp decrypt_round
		
	decrypt_done:
		pop		zl
		pop		zh
		rcall	store_state
		ret
			
; ======================================================================
; performs the key addition.
; state must be present in state registers
; and ZH:ZL must point to appropriate tweakey
; ======================================================================

key_addition:
	ld tmp0, z+
	eor s0, tmp0
	ld tmp0, z+
	eor s8, tmp0
	ld tmp0, z+
	eor s1, tmp0
	ld tmp0, z+
	eor s9, tmp0
	ld tmp0, z+
	eor s2, tmp0
	ld tmp0, z+
	eor s10, tmp0
	ld tmp0, z+
	eor s3, tmp0
	ld tmp0, z+
	eor s11, tmp0
	ld tmp0, z+
	eor s4, tmp0
	ld tmp0, z+
	eor s12, tmp0
	ld tmp0, z+
	eor s5, tmp0
	ld tmp0, z+
	eor s13, tmp0
	ld tmp0, z+
	eor s6, tmp0
	ld tmp0, z+
	eor s14, tmp0
	ld tmp0, z+
	eor s7, tmp0
	ld tmp0, z+
	eor s15, tmp0
	ret
	
;sbox_layer:
;inputs: tmp0, tmp1, tmp2, tmp3, tmp4, tmp5, tmp6, tmp7
;outputs: tmp0, tmp1, tmp2, tmp3, tmp4, tmp5, tmp6, tmp7
;temporary registers: tmp8, tmp9, tmp10
sbox_layer:
	;--- Feistel round 1
	mov tmp8, tmp1
	and tmp8, tmp2
	eor tmp8, tmp0 ; tmp8 = t0

	eor tmp8, tmp2 ; tmp8 = t2
	eor tmp8, tmp3 ; tmp8 = t2 + w3

	mov tmp9, tmp1
	eor tmp9, tmp3 ; tmp9 = t1

	eor tmp9, tmp2 ; tmp9 = tmp1 + w2

	and tmp9, tmp8
	eor tmp4, tmp9 ; w4 = ok

	eor tmp8, tmp3 ; tmp8 = t2
	eor tmp5, tmp8 ; w5 = ok

	mov tmp9, tmp1
	eor tmp9, tmp3
	and tmp9, tmp8
	eor tmp7, tmp9 ; w7 = ok

	eor tmp8, tmp2 ; tmp8 = t0
	and tmp8, tmp3
	eor tmp6, tmp8 ; w6 = ok
	
	;--- Feistel round 2
	mov tmp8, tmp4
	and tmp8, tmp5
	eor tmp8, tmp6 ; tmp8 = t0
	eor tmp0, tmp8 ; w0 = ok

	and tmp8, tmp7
	eor tmp8, tmp4 ; tmp8 = t2
	eor tmp1, tmp8 ; w1 = ok

	mov tmp9, tmp5
	or tmp9, tmp6
	eor tmp9, tmp7 ; tmp9 = t1
	eor tmp2, tmp9 ; w2 = ok

	and tmp9, tmp4
	eor tmp9, tmp5 ; tmp9 = t3
	eor tmp3, tmp9 ; w3 = ok

	;--- Feistel round 3
	mov tmp8, tmp1
	and tmp8, tmp2
	eor tmp8, tmp0 
	com tmp8 ; tmp8 = t0

	eor tmp8, tmp2 ; tmp8 = t2
	eor tmp8, tmp3 ; tmp8 = t2 + w3

	mov tmp9, tmp1
	eor tmp9, tmp3 ; tmp9 = t1

	eor tmp9, tmp2 ; tmp9 = tmp1 + w2

	and tmp9, tmp8
	eor tmp4, tmp9 ; w4 = ok

	eor tmp8, tmp3 ; tmp8 = t2
	eor tmp5, tmp8 ; w5 = ok

	mov tmp9, tmp1
	eor tmp9, tmp3
	and tmp9, tmp8
	eor tmp7, tmp9 ; w7 = ok

	eor tmp8, tmp2 ; tmp8 = t0
	and tmp8, tmp3
	eor tmp6, tmp8 ; w6 = ok
	ret

;sbox_inv_layer:
;inputs: tmp0, tmp1, tmp2, tmp3, tmp4, tmp5, tmp6, tmp7
;outputs: tmp0, tmp1, tmp2, tmp3, tmp4, tmp5, tmp6, tmp7
;temporary registers: tmp8, tmp9, tmp10
sbox_inv_layer:
	;--- Feistel round 1
	mov tmp8, tmp1
	and tmp8, tmp2
	eor tmp8, tmp0 
	com tmp8 ; tmp8 = t0

	eor tmp8, tmp2 ; tmp8 = t2
	eor tmp8, tmp3 ; tmp8 = t2 + w3

	mov tmp9, tmp1
	eor tmp9, tmp3 ; tmp9 = t1

	eor tmp9, tmp2 ; tmp9 = tmp1 + w2

	and tmp9, tmp8
	eor tmp4, tmp9 ; w4 = ok

	eor tmp8, tmp3 ; tmp8 = t2
	eor tmp5, tmp8 ; w5 = ok

	mov tmp9, tmp1
	eor tmp9, tmp3
	and tmp9, tmp8
	eor tmp7, tmp9 ; w7 = ok

	eor tmp8, tmp2 ; tmp8 = t0
	and tmp8, tmp3
	eor tmp6, tmp8 ; w6 = ok

	;--- Feistel round 2
	mov tmp8, tmp4
	and tmp8, tmp5
	eor tmp8, tmp6 ; tmp8 = t0
	eor tmp0, tmp8 ; w0 = ok

	and tmp8, tmp7
	eor tmp8, tmp4 ; tmp8 = t2
	eor tmp1, tmp8 ; w1 = ok

	mov tmp9, tmp5
	or tmp9, tmp6
	eor tmp9, tmp7 ; tmp9 = t1
	eor tmp2, tmp9 ; w2 = ok

	and tmp9, tmp4
	eor tmp9, tmp5 ; tmp9 = t3
	eor tmp3, tmp9 ; w3 = ok

	;--- Feistel round 3
	mov tmp8, tmp1
	and tmp8, tmp2
	eor tmp8, tmp0 ; tmp8 = t0

	eor tmp8, tmp2 ; tmp8 = t2
	eor tmp8, tmp3 ; tmp8 = t2 + w3

	mov tmp9, tmp1
	eor tmp9, tmp3 ; tmp9 = t1

	eor tmp9, tmp2 ; tmp9 = tmp1 + w2

	and tmp9, tmp8
	eor tmp4, tmp9 ; w4 = ok

	eor tmp8, tmp3 ; tmp8 = t2
	eor tmp5, tmp8 ; w5 = ok

	mov tmp9, tmp1
	eor tmp9, tmp3
	and tmp9, tmp8
	eor tmp7, tmp9 ; w7 = ok

	eor tmp8, tmp2 ; tmp8 = t0
	and tmp8, tmp3
	eor tmp6, tmp8 ; w6 = ok
	ret





;.cseg

.org 0x300

L1_H:
.db $00,$38,$52,$6a,$7b,$43,$29,$11,$96,$ae,$c4,$fc,$ed,$d5,$bf,$87
.db $d7,$ef,$85,$bd,$ac,$94,$fe,$c6,$41,$79,$13,$2b,$3a,$02,$68,$50
.db $3a,$02,$68,$50,$41,$79,$13,$2b,$ac,$94,$fe,$c6,$d7,$ef,$85,$bd
.db $ed,$d5,$bf,$87,$96,$ae,$c4,$fc,$7b,$43,$29,$11,$00,$38,$52,$6a
.db $e5,$dd,$b7,$8f,$9e,$a6,$cc,$f4,$73,$4b,$21,$19,$08,$30,$5a,$62
.db $32,$0a,$60,$58,$49,$71,$1b,$23,$a4,$9c,$f6,$ce,$df,$e7,$8d,$b5
.db $df,$e7,$8d,$b5,$a4,$9c,$f6,$ce,$49,$71,$1b,$23,$32,$0a,$60,$58
.db $08,$30,$5a,$62,$73,$4b,$21,$19,$9e,$a6,$cc,$f4,$e5,$dd,$b7,$8f
.db $fe,$c6,$ac,$94,$85,$bd,$d7,$ef,$68,$50,$3a,$02,$13,$2b,$41,$79
.db $29,$11,$7b,$43,$52,$6a,$00,$38,$bf,$87,$ed,$d5,$c4,$fc,$96,$ae
.db $c4,$fc,$96,$ae,$bf,$87,$ed,$d5,$52,$6a,$00,$38,$29,$11,$7b,$43
.db $13,$2b,$41,$79,$68,$50,$3a,$02,$85,$bd,$d7,$ef,$fe,$c6,$ac,$94
.db $1b,$23,$49,$71,$60,$58,$32,$0a,$8d,$b5,$df,$e7,$f6,$ce,$a4,$9c
.db $cc,$f4,$9e,$a6,$b7,$8f,$e5,$dd,$5a,$62,$08,$30,$21,$19,$73,$4b
.db $21,$19,$73,$4b,$5a,$62,$08,$30,$b7,$8f,$e5,$dd,$cc,$f4,$9e,$a6
.db $f6,$ce,$a4,$9c,$8d,$b5,$df,$e7,$60,$58,$32,$0a,$1b,$23,$49,$71

L1_L:
.db $00,$5c,$a9,$f5,$b3,$ef,$1a,$46,$c1,$9d,$68,$34,$72,$2e,$db,$87
.db $6d,$31,$c4,$98,$de,$82,$77,$2b,$ac,$f0,$05,$59,$1f,$43,$b6,$ea
.db $e0,$bc,$49,$15,$53,$0f,$fa,$a6,$21,$7d,$88,$d4,$92,$ce,$3b,$67
.db $8d,$d1,$24,$78,$3e,$62,$97,$cb,$4c,$10,$e5,$b9,$ff,$a3,$56,$0a
.db $24,$78,$8d,$d1,$97,$cb,$3e,$62,$e5,$b9,$4c,$10,$56,$0a,$ff,$a3
.db $49,$15,$e0,$bc,$fa,$a6,$53,$0f,$88,$d4,$21,$7d,$3b,$67,$92,$ce
.db $c4,$98,$6d,$31,$77,$2b,$de,$82,$05,$59,$ac,$f0,$b6,$ea,$1f,$43
.db $a9,$f5,$00,$5c,$1a,$46,$b3,$ef,$68,$34,$c1,$9d,$db,$87,$72,$2e
.db $a5,$f9,$0c,$50,$16,$4a,$bf,$e3,$64,$38,$cd,$91,$d7,$8b,$7e,$22
.db $c8,$94,$61,$3d,$7b,$27,$d2,$8e,$09,$55,$a0,$fc,$ba,$e6,$13,$4f
.db $45,$19,$ec,$b0,$f6,$aa,$5f,$03,$84,$d8,$2d,$71,$37,$6b,$9e,$c2
.db $28,$74,$81,$dd,$9b,$c7,$32,$6e,$e9,$b5,$40,$1c,$5a,$06,$f3,$af
.db $81,$dd,$28,$74,$32,$6e,$9b,$c7,$40,$1c,$e9,$b5,$f3,$af,$5a,$06
.db $ec,$b0,$45,$19,$5f,$03,$f6,$aa,$2d,$71,$84,$d8,$9e,$c2,$37,$6b
.db $61,$3d,$c8,$94,$d2,$8e,$7b,$27,$a0,$fc,$09,$55,$13,$4f,$ba,$e6
.db $0c,$50,$a5,$f9,$bf,$e3,$16,$4a,$cd,$91,$64,$38,$7e,$22,$d7,$8b

L2_H:
.db $00,$46,$f1,$b7,$a1,$e7,$50,$16,$7f,$39,$8e,$c8,$de,$98,$2f,$69
.db $67,$21,$96,$d0,$c6,$80,$37,$71,$18,$5e,$e9,$af,$b9,$ff,$48,$0e
.db $7a,$3c,$8b,$cd,$db,$9d,$2a,$6c,$05,$43,$f4,$b2,$a4,$e2,$55,$13
.db $1d,$5b,$ec,$aa,$bc,$fa,$4d,$0b,$62,$24,$93,$d5,$c3,$85,$32,$74
.db $70,$36,$81,$c7,$d1,$97,$20,$66,$0f,$49,$fe,$b8,$ae,$e8,$5f,$19
.db $17,$51,$e6,$a0,$b6,$f0,$47,$01,$68,$2e,$99,$df,$c9,$8f,$38,$7e
.db $0a,$4c,$fb,$bd,$ab,$ed,$5a,$1c,$75,$33,$84,$c2,$d4,$92,$25,$63
.db $6d,$2b,$9c,$da,$cc,$8a,$3d,$7b,$12,$54,$e3,$a5,$b3,$f5,$42,$04
.db $8a,$cc,$7b,$3d,$2b,$6d,$da,$9c,$f5,$b3,$04,$42,$54,$12,$a5,$e3
.db $ed,$ab,$1c,$5a,$4c,$0a,$bd,$fb,$92,$d4,$63,$25,$33,$75,$c2,$84
.db $f0,$b6,$01,$47,$51,$17,$a0,$e6,$8f,$c9,$7e,$38,$2e,$68,$df,$99
.db $97,$d1,$66,$20,$36,$70,$c7,$81,$e8,$ae,$19,$5f,$49,$0f,$b8,$fe
.db $fa,$bc,$0b,$4d,$5b,$1d,$aa,$ec,$85,$c3,$74,$32,$24,$62,$d5,$93
.db $9d,$db,$6c,$2a,$3c,$7a,$cd,$8b,$e2,$a4,$13,$55,$43,$05,$b2,$f4
.db $80,$c6,$71,$37,$21,$67,$d0,$96,$ff,$b9,$0e,$48,$5e,$18,$af,$e9
.db $e7,$a1,$16,$50,$46,$00,$b7,$f1,$98,$de,$69,$2f,$39,$7f,$c8,$8e

L2_L:
.db $00,$4b,$af,$e4,$33,$78,$9c,$d7,$74,$3f,$db,$90,$47,$0c,$e8,$a3
.db $12,$59,$bd,$f6,$21,$6a,$8e,$c5,$66,$2d,$c9,$82,$55,$1e,$fa,$b1
.db $6f,$24,$c0,$8b,$5c,$17,$f3,$b8,$1b,$50,$b4,$ff,$28,$63,$87,$cc
.db $7d,$36,$d2,$99,$4e,$05,$e1,$aa,$09,$42,$a6,$ed,$3a,$71,$95,$de
.db $1b,$50,$b4,$ff,$28,$63,$87,$cc,$6f,$24,$c0,$8b,$5c,$17,$f3,$b8
.db $09,$42,$a6,$ed,$3a,$71,$95,$de,$7d,$36,$d2,$99,$4e,$05,$e1,$aa
.db $74,$3f,$db,$90,$47,$0c,$e8,$a3,$00,$4b,$af,$e4,$33,$78,$9c,$d7
.db $66,$2d,$c9,$82,$55,$1e,$fa,$b1,$12,$59,$bd,$f6,$21,$6a,$8e,$c5
.db $b1,$fa,$1e,$55,$82,$c9,$2d,$66,$c5,$8e,$6a,$21,$f6,$bd,$59,$12
.db $a3,$e8,$0c,$47,$90,$db,$3f,$74,$d7,$9c,$78,$33,$e4,$af,$4b,$00
.db $de,$95,$71,$3a,$ed,$a6,$42,$09,$aa,$e1,$05,$4e,$99,$d2,$36,$7d
.db $cc,$87,$63,$28,$ff,$b4,$50,$1b,$b8,$f3,$17,$5c,$8b,$c0,$24,$6f
.db $aa,$e1,$05,$4e,$99,$d2,$36,$7d,$de,$95,$71,$3a,$ed,$a6,$42,$09
.db $b8,$f3,$17,$5c,$8b,$c0,$24,$6f,$cc,$87,$63,$28,$ff,$b4,$50,$1b
.db $c5,$8e,$6a,$21,$f6,$bd,$59,$12,$b1,$fa,$1e,$55,$82,$c9,$2d,$66
.db $d7,$9c,$78,$33,$e4,$af,$4b,$00,$a3,$e8,$0c,$47,$90,$db,$3f,$74 

L1_H_INV:
.db $00,$e7,$77,$90,$2a,$cd,$5d,$ba,$63,$84,$14,$f3,$49,$ae,$3e,$d9
.db $dc,$3b,$ab,$4c,$f6,$11,$81,$66,$bf,$58,$c8,$2f,$95,$72,$e2,$05
.db $ae,$49,$d9,$3e,$84,$63,$f3,$14,$cd,$2a,$ba,$5d,$e7,$00,$90,$77
.db $72,$95,$05,$e2,$58,$bf,$2f,$c8,$11,$f6,$66,$81,$3b,$dc,$4c,$ab
.db $29,$ce,$5e,$b9,$03,$e4,$74,$93,$4a,$ad,$3d,$da,$60,$87,$17,$f0
.db $f5,$12,$82,$65,$df,$38,$a8,$4f,$96,$71,$e1,$06,$bc,$5b,$cb,$2c
.db $87,$60,$f0,$17,$ad,$4a,$da,$3d,$e4,$03,$93,$74,$ce,$29,$b9,$5e
.db $5b,$bc,$2c,$cb,$71,$96,$06,$e1,$38,$df,$4f,$a8,$12,$f5,$65,$82
.db $82,$65,$f5,$12,$a8,$4f,$df,$38,$e1,$06,$96,$71,$cb,$2c,$bc,$5b
.db $5e,$b9,$29,$ce,$74,$93,$03,$e4,$3d,$da,$4a,$ad,$17,$f0,$60,$87
.db $2c,$cb,$5b,$bc,$06,$e1,$71,$96,$4f,$a8,$38,$df,$65,$82,$12,$f5
.db $f0,$17,$87,$60,$da,$3d,$ad,$4a,$93,$74,$e4,$03,$b9,$5e,$ce,$29
.db $ab,$4c,$dc,$3b,$81,$66,$f6,$11,$c8,$2f,$bf,$58,$e2,$05,$95,$72
.db $77,$90,$00,$e7,$5d,$ba,$2a,$cd,$14,$f3,$63,$84,$3e,$d9,$49,$ae
.db $05,$e2,$72,$95,$2f,$c8,$58,$bf,$66,$81,$11,$f6,$4c,$ab,$3b,$dc
.db $d9,$3e,$ae,$49,$f3,$14,$84,$63,$ba,$5d,$cd,$2a,$90,$77,$e7,$00

L1_L_INV:
.db $00,$9e,$04,$9a,$d1,$4f,$d5,$4b,$13,$8d,$17,$89,$c2,$5c,$c6,$58
.db $05,$9b,$01,$9f,$d4,$4a,$d0,$4e,$16,$88,$12,$8c,$c7,$59,$c3,$5d
.db $f6,$68,$f2,$6c,$27,$b9,$23,$bd,$e5,$7b,$e1,$7f,$34,$aa,$30,$ae
.db $f3,$6d,$f7,$69,$22,$bc,$26,$b8,$e0,$7e,$e4,$7a,$31,$af,$35,$ab
.db $39,$a7,$3d,$a3,$e8,$76,$ec,$72,$2a,$b4,$2e,$b0,$fb,$65,$ff,$61
.db $3c,$a2,$38,$a6,$ed,$73,$e9,$77,$2f,$b1,$2b,$b5,$fe,$60,$fa,$64
.db $cf,$51,$cb,$55,$1e,$80,$1a,$84,$dc,$42,$d8,$46,$0d,$93,$09,$97
.db $ca,$54,$ce,$50,$1b,$85,$1f,$81,$d9,$47,$dd,$43,$08,$96,$0c,$92
.db $ae,$30,$aa,$34,$7f,$e1,$7b,$e5,$bd,$23,$b9,$27,$6c,$f2,$68,$f6
.db $ab,$35,$af,$31,$7a,$e4,$7e,$e0,$b8,$26,$bc,$22,$69,$f7,$6d,$f3
.db $58,$c6,$5c,$c2,$89,$17,$8d,$13,$4b,$d5,$4f,$d1,$9a,$04,$9e,$00
.db $5d,$c3,$59,$c7,$8c,$12,$88,$16,$4e,$d0,$4a,$d4,$9f,$01,$9b,$05
.db $97,$09,$93,$0d,$46,$d8,$42,$dc,$84,$1a,$80,$1e,$55,$cb,$51,$cf
.db $92,$0c,$96,$08,$43,$dd,$47,$d9,$81,$1f,$85,$1b,$50,$ce,$54,$ca
.db $61,$ff,$65,$fb,$b0,$2e,$b4,$2a,$72,$ec,$76,$e8,$a3,$3d,$a7,$39
.db $64,$fa,$60,$fe,$b5,$2b,$b1,$2f,$77,$e9,$73,$ed,$a6,$38,$a2,$3c

L2_H_INV:
.db $00,$1e,$b9,$a7,$19,$07,$a0,$be,$a8,$b6,$11,$0f,$b1,$af,$08,$16
.db $6a,$74,$d3,$cd,$73,$6d,$ca,$d4,$c2,$dc,$7b,$65,$db,$c5,$62,$7c
.db $7e,$60,$c7,$d9,$67,$79,$de,$c0,$d6,$c8,$6f,$71,$cf,$d1,$76,$68
.db $14,$0a,$ad,$b3,$0d,$13,$b4,$aa,$bc,$a2,$05,$1b,$a5,$bb,$1c,$02
.db $7b,$65,$c2,$dc,$62,$7c,$db,$c5,$d3,$cd,$6a,$74,$ca,$d4,$73,$6d
.db $11,$0f,$a8,$b6,$08,$16,$b1,$af,$b9,$a7,$00,$1e,$a0,$be,$19,$07
.db $05,$1b,$bc,$a2,$1c,$02,$a5,$bb,$ad,$b3,$14,$0a,$b4,$aa,$0d,$13
.db $6f,$71,$d6,$c8,$76,$68,$cf,$d1,$c7,$d9,$7e,$60,$de,$c0,$67,$79
.db $86,$98,$3f,$21,$9f,$81,$26,$38,$2e,$30,$97,$89,$37,$29,$8e,$90
.db $ec,$f2,$55,$4b,$f5,$eb,$4c,$52,$44,$5a,$fd,$e3,$5d,$43,$e4,$fa
.db $f8,$e6,$41,$5f,$e1,$ff,$58,$46,$50,$4e,$e9,$f7,$49,$57,$f0,$ee
.db $92,$8c,$2b,$35,$8b,$95,$32,$2c,$3a,$24,$83,$9d,$23,$3d,$9a,$84
.db $fd,$e3,$44,$5a,$e4,$fa,$5d,$43,$55,$4b,$ec,$f2,$4c,$52,$f5,$eb
.db $97,$89,$2e,$30,$8e,$90,$37,$29,$3f,$21,$86,$98,$26,$38,$9f,$81
.db $83,$9d,$3a,$24,$9a,$84,$23,$3d,$2b,$35,$92,$8c,$32,$2c,$8b,$95
.db $e9,$f7,$50,$4e,$f0,$ee,$49,$57,$41,$5f,$f8,$e6,$58,$46,$e1,$ff

L2_L_INV:
.db $00,$54,$be,$ea,$d8,$8c,$66,$32,$a5,$f1,$1b,$4f,$7d,$29,$c3,$97
.db $bf,$eb,$01,$55,$67,$33,$d9,$8d,$1a,$4e,$a4,$f0,$c2,$96,$7c,$28
.db $e5,$b1,$5b,$0f,$3d,$69,$83,$d7,$40,$14,$fe,$aa,$98,$cc,$26,$72
.db $5a,$0e,$e4,$b0,$82,$d6,$3c,$68,$ff,$ab,$41,$15,$27,$73,$99,$cd
.db $d6,$82,$68,$3c,$0e,$5a,$b0,$e4,$73,$27,$cd,$99,$ab,$ff,$15,$41
.db $69,$3d,$d7,$83,$b1,$e5,$0f,$5b,$cc,$98,$72,$26,$14,$40,$aa,$fe
.db $33,$67,$8d,$d9,$eb,$bf,$55,$01,$96,$c2,$28,$7c,$4e,$1a,$f0,$a4
.db $8c,$d8,$32,$66,$54,$00,$ea,$be,$29,$7d,$97,$c3,$f1,$a5,$4f,$1b
.db $d8,$8c,$66,$32,$00,$54,$be,$ea,$7d,$29,$c3,$97,$a5,$f1,$1b,$4f
.db $67,$33,$d9,$8d,$bf,$eb,$01,$55,$c2,$96,$7c,$28,$1a,$4e,$a4,$f0
.db $3d,$69,$83,$d7,$e5,$b1,$5b,$0f,$98,$cc,$26,$72,$40,$14,$fe,$aa
.db $82,$d6,$3c,$68,$5a,$0e,$e4,$b0,$27,$73,$99,$cd,$ff,$ab,$41,$15
.db $0e,$5a,$b0,$e4,$d6,$82,$68,$3c,$ab,$ff,$15,$41,$73,$27,$cd,$99
.db $b1,$e5,$0f,$5b,$69,$3d,$d7,$83,$14,$40,$aa,$fe,$cc,$98,$72,$26
.db $eb,$bf,$55,$01,$33,$67,$8d,$d9,$4e,$1a,$f0,$a4,$96,$c2,$28,$7c
.db $54,$00,$ea,$be,$8c,$d8,$32,$66,$f1,$a5,$4f,$1b,$29,$7d,$97,$c3
